/*********************************************************************/
/* Project Name: SPI_Slave.mcp                                       */
/* Source fle name: SPI_Slave.c                                      */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: SPI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The data received by SPI is displayed in Port E      */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

typedef unsigned char UINT8;

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
  SOPT1 = 0x23;    /* Watchdog disable */  
  SCGC1 = 0x00;    /* Disable Bus clock to unused peripherals */
  SCGC2 = 0x02;    /* Bus Clock to the SPI2 module is enabled */
}

void GPIO_Init(void) { 
  
  PTCDD = (UINT8) (PTCD | 0x3F);    /* Configure PTC0-PTC5 as outputs */
  PTEDD = (UINT8) (PTED | 0xC0);    /* Configure PTE6 and PTE7 pins as outputs */
  PTCD = 0x3F;           /* Put 1's in port C in order to turn off the LEDs */
  PTED = 0xC0;           /* Put 1's in port E in order to turn off the LEDs */
}

void SPI_configuration (void) {
 
  SPI2BR = 0x75;        /* Select the highest baud rate prescaler divisor and the highest baud rate divisor */
  SPI2C1 = 0xC2;        /* SPI Interrupt enable, system enable and slave mode selected */ 
  SPI2C2 = 0x10;        /* Different pins for data input and data output */
} 

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */         
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  SPI_configuration();  /* Function that initializes the SPI module */

  EnableInterrupts; /* enable interrupts */
  
  for(;;) { 

  _Wait;            /* Wait for an interrupt */

  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    

void interrupt VectorNumber_Vspi2 SPI_ISR(void) {

  UINT8 temp, buffer;

  while (PTDD_PTDD0);
  temp = SPI2S;         /* Clear register flag */
  buffer = ~SPI2D;				  /* Read data register to clear receive flag */
                            /* on the LEDs (The LEDs turn on with 0's) */
  PTED = (UINT8) (buffer & 0xC0);   /* Move the received value to port E */
  PTCD = (UINT8) (buffer & 0x3F);   /* Move the received value to port C */
}
